set autoscale 

unset xtics
unset ytics

set style line  3 lt -1 lw 3 lc rgb "#000000"
set style line  2 lt -1 lw 3 lc rgb "#FF0000"
set style line  1 lt -1 lw 3 lc rgb "#0000FF"

offset = 0 

unset border
#set border 15

conjugate = 9
complex = 9
NE1 = 2

titles = "a _{1g} t _{1g} t _{1g} t _{1g} e _g e _g t _{2g}  t _{2g} t _{2g}"

set terminal postscript portrait enhanced color  "Verdana" 8

#terminal for 10000x10000 png

#set terminal pngcairo size 10000, 10000 enhanced font 'Verdana,1'
#set out 'RIXS_Tensor_Oh_irreps.png'

#terminal for input file to include in latex document

#set terminal cairolatex pdf size 20cm, 20cm color input

#terminal for standalone latex document only including the plot

#set terminal cairolatex pdf size 20cm, 20cm color standalone header \
"\\usepackage[T1]{fontenc}\n\\usepackage{mathptmx}\n\\usepackage{helvet}\n\\usepackage{amsmath}"

set output 'RIXS_Tensor_Oh_irreps.ps'

t = 0
b = 0
l = 0
r = 0

set multiplot layout complex, conjugate

set lmargin 0
set rmargin 0
set tmargin 0
set bmargin 0

do for [i = 1:conjugate]{			#loop over rows (complex conjugate of polarization)
  
	if(i == 1){b = 1; t = 4}
	else{if(i == 9){b = 1; t = 4}
	else{b = 1; t = 4}}


	do for [j = 1:complex]{		#loop over columns (complex polarizaiton)
	
		if(j == 1){r = 8; l = 2}
		else{if(j == 9){r = 8; l = 2}
		else{r = 8; l = 2}}
		
		a = t+b+l+r
		set border a
		
		set xlabel word(titles, 2*j - 1).word(titles, 2*j)." | ".word(titles, 2*i - 1).word(titles, 2*i) font "Verdana,8"
		set xlabel offset 0, 10
		
		set xrange [-0.5:7.5]
		set yrange [-0.25:0.25]  
		
		plot for [ne1=2:2] sprintf("data/RIXS_Tensor_Oh_irreps_%d_%d_%d.dat",i, j, ne1)  using 1:(column(2) + offset*ne1) notitle with lines ls 1,\
			 for [ne1=2:2] sprintf("data/RIXS_Tensor_Oh_irreps_%d_%d_%d.dat",i, j, ne1)  using 1:(column(3) + offset*ne1) notitle with lines ls 2
				
		unset border
	}
}

unset multiplot

